<?php
/**
 * Plugin Name:           AutomatorWP - PeepSo
 * Plugin URI:            https://automatorwp.com/add-ons/peepso/
 * Description:           Connect AutomatorWP with PeepSo.
 * Version:               1.0.7
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-peepso
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\PeepSo
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_PeepSo {

    /**
     * @var         AutomatorWP_PeepSo $instance The one true AutomatorWP_PeepSo
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_PeepSo self::$instance The one true AutomatorWP_PeepSo
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_PeepSo();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_PEEPSO_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_PEEPSO_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_PEEPSO_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_PEEPSO_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/change-avatar.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/change-cover-image.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/write-activity-post.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/comment-activity-post.php';
            // PeepSo Likes
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/like-profile.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-like-profile.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/like-post.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-like-post.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/like-photo.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-like-photo.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/like-video.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-like-video.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/like-comment.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-like-comment.php';
            // PeepSo Reactions
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/react-profile.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-react-profile.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/react-post.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-react-post.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/react-photo.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-react-photo.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/react-video.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-react-video.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/react-comment.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/get-react-comment.php';

            // PeepSo Friends
            if( class_exists( 'PeepSoFriendsPlugin' ) ) {
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/send-friend-request.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/accept-friend-request.php';
            }

            // PeepSo Groups
            if( class_exists( 'PeepSoGroupsPlugin' ) ) {
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/create-group.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/join-group.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/leave-group.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/change-group-avatar.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/change-group-cover.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/request-join-group.php';
            }

            // PeepSo Friends
            if( class_exists( 'PeepSoMessagesPlugin' ) ) {
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/triggers/new-conversation.php';
            }

            // Actions
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/actions/add-user-activity.php';
            require_once AUTOMATORWP_PEEPSO_DIR . 'includes/actions/add-user-notification.php';

            // PeepSo Groups
            if( class_exists( 'PeepSoGroupsPlugin' ) ) {
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/actions/add-user-group.php';
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/actions/remove-user-group.php';
            }

            // PeepSo Messages
            if( class_exists( 'PeepSoMessagesPlugin' ) ) {
                require_once AUTOMATORWP_PEEPSO_DIR . 'includes/actions/send-private-message.php';
            }

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'peepso', array(
            'label' => 'PeepSo',
            'icon'  => AUTOMATORWP_PEEPSO_URL . 'assets/peepso.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'PeepSo' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_PeepSo instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_PeepSo The one true AutomatorWP_PeepSo
 */
function AutomatorWP_PeepSo() {
    return AutomatorWP_PeepSo::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_PeepSo' );
